#
# Filename: 
#    reduce_image_size.py
#
# Usage: 
#    python3 reduce_image_size.py
#
# Date:
#    June, 07, 2023
#
# このスクリプトは images フォルダ内にある
# png、gif、jpeg 画像に変更を加えて、ユーザーが指定した % の分だけ
# 画像サイズを減らします。
#
# png と gif ファイル形式の場合、サイズを変更した後
# jpeg に変換します。
#
# また、0% を選んだ場合、ファイルサイズの変更はせずに
# png と gif 形式の画像ファイルを jpeg に変換します。
#
# このスクリプトを走らせて
#    'ModuleNotFoundError: No module named 'PIL''
# エラーが出た場合、
# pip3 install pillow
# を実行して PIL モジュールをインストールしてください。
#


import os
from PIL import Image

# ファイルサイズを減らす画像が入っているディレクトリ
input_dir = 'images'

# サイズを減らした画像を保存するディレクトリ（存在しなければ作成）
output_dir = 'output_images'
os.makedirs(output_dir, exist_ok=True)

# ユーザーにサイズを減らす割合を選んでもらう
print(" ")
print(" ")
print("このスクリプトは images フォルダ内にある")
print("png、gif、jpeg 画像に変更を加えて、ユーザーが指定した % の分だけ")
print("画像サイズを減らします。")
print("")
print("png と gif ファイル形式の場合、サイズを変更した後")
print("jpeg に変換します。")
print("")
print("また、0% を選んだ場合、ファイルサイズの変更はせずに")
print("png と gif 形式の画像ファイルを jpeg に変換します。")
print(" ")
print("画像サイズを何%減らしますか？ 選択肢: 0, 10, 20, 30, 40, 50, 60, 70")

percentage = int(input())
assert percentage in [0, 10, 20, 30, 40, 50, 60, 70], "選択肢外の値です。"

for filename in os.listdir(input_dir):
    if filename.endswith(('.jpg', '.jpeg', '.png', '.gif')):
        img = Image.open(os.path.join(input_dir, filename))
        
        # ユーザーが選んだ割合で画像の解像度を減らす（0% の場合はリサイズなし）
        if percentage != 0:
            new_size = (int(img.width * (1 - percentage / 100)), int(img.height * (1 - percentage / 100)))
            img = img.resize(new_size, Image.LANCZOS)
        
        # jpg に変換
        output_path = os.path.join(output_dir, os.path.splitext(filename)[0] + '.jpg')
        img = img.convert('RGB')  # jpg は RGB フォーマットを必要とする
        
        # jpg フォーマットに保存
        img.save(output_path, "JPEG", quality=90)
