#
# Filename: 
#    reduce_image_size.py
#
# Usage: 
#    python3 reduce_image_size.py
#
# Date:
#    June, 07, 2023
#
# This script modifies png, gif, and jpeg formatted images in the 'images' folder
# 
# to reduce the image size by a percentage specified by the user.
# 
# For png and gif file formatted files, after resizing, it will convert them to jpeg.
# 
# Additionally, if 0% is selected, it will convert png and gif formatted files to jpeg
# 
# without changing the file size.
# 
# If you run this script and get this error:
# 
#      'ModuleNotFoundError: No module named 'PIL'',
# 
# then just execute
# 
#      pip3 install pillow
# 
# to install the PIL module.
# 

import os
from PIL import Image

# input folder
input_dir = 'images'

# output_dir.  If not exists, the folder will be created
output_dir = 'output_images'
os.makedirs(output_dir, exist_ok=True)

# Ask user to enter the percentage to reduce
print(" ")
print(" ")
print("This script takes png, gif, and jpeg formatted files found in the")
print("[images] folder and reduce the size by the percentage specified")
print("by the user.")
print("")
print("If the file is png or gif, the file will be converted to")
print("jpeg after the size is reduced.")
print("")
print("If you enter '0', the file size will be unchanged and")
print("the png and gif files will be converted to jpeg.")
print(" ")
print("By what percentage would you like to reduce? (0, 10, 20, 30, 40, 50, 60, or 70")

percentage = int(input())
assert percentage in [0, 10, 20, 30, 40, 50, 60, 70], "ERROR: Out of range"

for filename in os.listdir(input_dir):
    if filename.endswith(('.jpg', '.jpeg', '.png', '.gif')):
        img = Image.open(os.path.join(input_dir, filename))
        
        # Reduce the file size.  If '0' then no change in size
        if percentage != 0:
            new_size = (int(img.width * (1 - percentage / 100)), int(img.height * (1 - percentage / 100)))
            img = img.resize(new_size, Image.LANCZOS)
        
        # Convert to jpeg
        output_path = os.path.join(output_dir, os.path.splitext(filename)[0] + '.jpg')
        img = img.convert('RGB')  # jpeg must be RGB
        
        # Save as jpeg filejpg
        img.save(output_path, "JPEG", quality=90)
